***********************************************************************
*** Table 3: Interaction terms with bubble measures ***
***********************************************************************

* Housekeeping 
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"

gen hp_bubble_cred_nfe    = ind_hp_inc_exu*nfecredit_gdp_gap
gen no_hp_bubble_cred_nfe = (1-ind_hp_inc_exu)*nfecredit_gdp_gap

gen hp_bubble_cred_h      = ind_hp_inc_exu*hcredit_gdp_gap
gen no_hp_bubble_cred_h   = (1-ind_hp_inc_exu)*hcredit_gdp_gap

gen hp_bubble_cred_p      = ind_hp_inc_exu*pcredit_gdp_gap
gen no_hp_bubble_cred_p   = (1-ind_hp_inc_exu)*pcredit_gdp_gap

* Column (1)
gen crisis_prob = 1
gen nr_countries = 18
gen Model  = 1
logit crisis4_12 hp_bubble_cred_p  no_hp_bubble_cred_p  i.country_id if no_hp_bubble_cred_h  != ., robust cluster(period)
est store p11
predict p11, p
bysort start_crisis : count if p11 !=.
roctab crisis4_12 p11
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 18
estadd scalar Crisis = 25
replace crisis_prob = p11
replace nr_countries = 18
replace Model  = 1
preserve
drop if country == "AUT" || country == "CAN" 
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
save stats_interaction, replace
restore

* Column (2)
logit crisis4_12 hp_bubble_cred_nfe  no_hp_bubble_cred_nfe  i.country_id, robust cluster(period)
est store p12
predict p12, p
bysort start_crisis : count if p12 !=.
roctab crisis4_12 p12
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 18
estadd scalar Crisis = 25
replace crisis_prob = p12
replace nr_countries = 18
replace Model  = 2
preserve
drop if country == "AUT" || country == "CAN" 
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
save help_inter, replace
append using stats_interaction
save stats_interaction, replace
restore 


* Column (3)
logit crisis4_12 hp_bubble_cred_h no_hp_bubble_cred_h i.country_id, robust cluster(period)
est store p13
predict p13, p
bysort start_crisis : count if p13 !=.
roctab crisis4_12 p13
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 18
estadd scalar Crisis = 25
replace crisis_prob = p13
replace nr_countries = 18
replace Model  = 3
preserve
drop if country == "AUT" || country == "CAN" 
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
save help_inter, replace
append using stats_interaction
save stats_interaction, replace
restore 

* Column (4)
logit crisis4_12 hp_bubble_cred_h no_hp_bubble_cred_h hp_bubble_cred_nfe  no_hp_bubble_cred_nfe  i.country_id, robust cluster(period)
est store p14
predict p14, p
bysort start_crisis : count if p14 !=.
roctab crisis4_12 p14
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 18
estadd scalar Crisis = 25
replace crisis_prob = p14
replace nr_countries = 18
replace Model  = 4
preserve
drop if country == "AUT" || country == "CAN" 
drop country_id
egen country_id = group(country)
** This is to calculate model evaluation measures 
do "$codePath\stats"
cd "$outputPath" 
keep if country == "USA"
keep if quarter == 140
keep TPR90 TPR95 FPR90 FPR95 Rel_use90 Rel_use95 Model
save help_inter, replace
* Saving measures of relative usefulness, true positive rates, false positive rates in csv file (added "manually" to tex file)
append using stats_interaction
save stats_interaction, replace
outsheet using "stats_table3.csv", comma replace
restore

** Labels for table
label variable hp_bubble_cred_p  "Bubble x Credit/GDP gap"
label variable no_hp_bubble_cred_p  "No bubble x Credit/GDP gap"
label variable hp_bubble_cred_h  "Bubble x Household credit/GDP gap"
label variable no_hp_bubble_cred_h  "No bubble x Household credit/GDP gap"
label variable hp_bubble_cred_nfe  "Bubble x NFE credit/GDP gap"
label variable no_hp_bubble_cred_nfe  "No bubble x NFE credit/GDP gap"


** All output is saved as a LaTex file
cd "$outputTables"
esttab p11 p12 p13 p14 using Table_inter.tex, se indicate("Country fixed effects = *country_id") drop(_cons) ///
											   order(hp_bubble_cred_p  no_hp_bubble_cred_p hp_bubble_cred_h  no_hp_bubble_cred_h hp_bubble_cred_nfe  no_hp_bubble_cred_nfe) ///
											   star(* 0.1 ** 0.05 *** 0.01) obslast varwidth(30) wrap nomtitles ///
											   label scalars("r2_p Pseudo R-Squared" AUROC Countries Crisis) ///
											   nodepvars nonotes replace

											   
